
(* 2x1 flyways w/ 1 xbots - linear, arc target, block buffer, release buffer, clear macro, save macro, run macro *)
FUNCTION_BLOCK Example01_longaxismotion
	(*move xbot 1 to 120,180*)
	PMC_XYMotion1(PM_Controller := PM_Controller,Execute := Execute,cmdLB := 1,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.12,PosY := 0.18,EndVel := 0,MaxVel := 1.0,MaxAcc := 10);

	(*arc motion counter clockwise to 120,60*)
	PMC_ArcMotionTarget1(PM_Controller := PM_Controller,Execute := PMC_XYMotion1.Done,cmdLB := 2,XbotID := 1,Mode := 0,AType := 0,Dir := 1,EndVel := 0,MaxVel := 1,MaxAcc := 10,PosX := 0.12,PosY := 0.06,Radius := 0.06);

	(*linear motion to 360,60*)
	PMC_XYMotion2(PM_Controller := PM_Controller,Execute := PMC_ArcMotionTarget1.Done,cmdLB := 3,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.36,PosY := 0.06,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*arc motion to 360,180*)
	PMC_ArcMotionTarget2(PM_Controller := PM_Controller,Execute := PMC_XYMotion2.Done,cmdLB := 4,XbotID := 1,Mode := 0,AType := 0,Dir := 1,EndVel := 0,MaxVel := 1.0,MaxAcc := 10,PosX := 0.36,PosY := 0.18,Radius := 0.06);

	(*linear motion to 120,180*)
	PMC_XYMotion3(PM_Controller := PM_Controller,Execute := PMC_ArcMotionTarget2.Done,cmdLB := 5,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.12,PosY := 0.18,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*block xbot 1 motion buffer	*)
	PMC_MotionBufferCtrl1(PM_Controller := PM_Controller,Execute := PMC_XYMotion3.Done,Level := 0,XbotID := 1);

	(*arc motion to 120,60 non-zero ending speed*)
	PMC_ArcMotionTarget3(PM_Controller := PM_Controller,Execute := PMC_MotionBufferCtrl1.Done,cmdLB := 7,XbotID := 1,Mode := 0,AType := 0,Dir := 1,EndVel := 1,MaxVel := 1,MaxAcc := 10,PosX := 0.12,PosY := 0.06,Radius := 0.06);

	(*linear motion to 360,60 non-zero ending speed*)
	PMC_XYMotion4(PM_Controller := PM_Controller,Execute := PMC_ArcMotionTarget3.Ack,cmdLB := 8,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.36,PosY := 0.06,EndVel := 1,MaxVel := 1,MaxAcc := 10);

	(*arc motion to 360,180 non-zero ending speed*)
	PMC_ArcMotionTarget4(PM_Controller := PM_Controller,Execute := PMC_XYMotion4.Ack,cmdLB := 9,XbotID := 1,Mode := 0,AType := 0,Dir := 1,EndVel := 1,MaxVel := 1,MaxAcc := 10,PosX := 0.36,PosY := 0.18,Radius := 0.06);

	(*linear move to 120,180 zero ending speed*)
	PMC_XYMotion5(PM_Controller := PM_Controller,Execute := PMC_ArcMotionTarget4.Ack,cmdLB := 10,XbotID := 1,Mode := 0,Type_ := 0,PosX := 0.12,PosY := 0.18,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*unblock xbot 1 buffer*)
	PMC_MotionBufferCtrl2(PM_Controller := PM_Controller,Execute := PMC_XYMotion5.Ack,Level := 1,XbotID := 1);

	(*clear macro 128*)
	PMC_ClearMacro1(PM_Controller := PM_Controller,Execute := PMC_MotionBufferCtrl2.Done,MacroID := 128);

	(*arc motion to 120,60 non-zero ending speed (macro 128)*)
	PMC_ArcMotionTarget5(PM_Controller := PM_Controller,Execute := PMC_ClearMacro1.Done,cmdLB := 13,XbotID := 128,Mode := 0,AType := 0,Dir := 1,EndVel := 1,MaxVel := 1,MaxAcc := 10,PosX := 0.12,PosY := 0.06,Radius := 0.06);

	(*linear motion to 360,60 non-zero ending speed (macro 128)*)
	PMC_XYMotion6(PM_Controller := PM_Controller,Execute := PMC_ArcMotionTarget5.Done,cmdLB := 14,XbotID := 128,Mode := 0,Type_ := 0,PosX := 0.36,PosY := 0.06,EndVel := 1,MaxVel := 1,MaxAcc := 10);

	(*arc motion to 360,180 non-zero ending speed (macro 128)*)
	PMC_ArcMotionTarget6(PM_Controller := PM_Controller,Execute := PMC_XYMotion6.Done,cmdLB := 15,XbotID := 128,Mode := 0,AType := 0,Dir := 1,EndVel := 1,MaxVel := 1,MaxAcc := 10,PosX := 0.36,PosY := 0.18,Radius := 0.06);

	(*linear move to 120,180 zero ending speed*)
	PMC_XYMotion7(PM_Controller := PM_Controller,Execute := PMC_ArcMotionTarget6.Done,cmdLB := 16,XbotID := 128,Mode := 0,Type_ := 0,PosX := 0.12,PosY := 0.18,EndVel := 0,MaxVel := 1,MaxAcc := 10);

	(*save macro 128*)
	PMC_SaveMacro1(PM_Controller := PM_Controller,Execute := PMC_XYMotion7.Done,MacroID := 128);

	(*run macro 128 using xbot 1*)
	PMC_RunMacro1(PM_Controller := PM_Controller,Execute := PMC_SaveMacro1.Done AND PMC_XYMotion5.Done,cmdLB := 18,MacroID := 128,XbotID := 1);


	Done := PMC_RunMacro1.Done;
END_FUNCTION_BLOCK
